#ifndef __IDropFileListener__
#define __IDropFileListener__

#include "../Events/CDropEvent.hpp"
using Exponent::GUI::Events::CDropEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IDropFileListener IDropFileListener.hpp
			 * @brief Allows for responding to files being dropped on the controls/ / window
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IDropFileListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IDropFileListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IDropFileListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IDropFileListener() { }

//	===========================================================================

				/**
				 * Handle an object being dropped
				 * @param event The drop event to handle
				 */
				virtual void handleFileDrop(const CDropEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IDropFileListener.hpp